/*
 * Decompiled with CFR 0.152.
 */
package com.ruimo.pluginlib;

import com.ruimo.pluginlib.Plugin;
import com.ruimo.pluginlib.PluginClassLoader;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginRepository<T extends Plugin> {
    public static final String PLUGIN_CONFIG_FILE_NAME = "plugins.conf";
    private Set<T> repository = new HashSet<T>();

    public PluginRepository(final File pluginDir) throws IOException {
        File[] files;
        if (!pluginDir.exists()) {
            throw new FileNotFoundException("The plugin directory (" + pluginDir + ") does not exist.");
        }
        if (!pluginDir.isDirectory()) {
            throw new IOException("This is not a directory (" + pluginDir + ").");
        }
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                try {
                    return new PluginClassLoader(this.getClass().getClassLoader(), pluginDir);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        for (File f : files = pluginDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        })) {
            JarFile jf = new JarFile(f);
            this.loadPlugin(classLoader, jf);
        }
    }

    public Iterable<T> plugins() {
        return Collections.unmodifiableCollection(new HashSet<T>(this.repository));
    }

    public PluginRepository<T> register(T plugin) {
        if (plugin == null) {
            throw new NullPointerException();
        }
        if (this.repository.contains(plugin)) {
            throw new IllegalArgumentException("The plugin '" + plugin.getName() + "' is already registered.");
        }
        this.repository.add(plugin);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadPlugin(ClassLoader classLoader, JarFile jf) throws IOException {
        JarEntry je = jf.getJarEntry(PLUGIN_CONFIG_FILE_NAME);
        if (je == null) {
            return;
        }
        HashMap<String, PluginRepository> map = new HashMap<String, PluginRepository>();
        map.put("plugins", this);
        Binding binding = new Binding(map);
        GroovyShell shell = new GroovyShell(classLoader, binding);
        InputStream is = null;
        try {
            is = jf.getInputStream(je);
            shell.evaluate(is, je.getName() + " in " + jf.getName());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

