/*
 * Decompiled with CFR 0.152.
 */
package com.ruimo.pluginlib;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class PluginClassLoader
extends ClassLoader {
    final File pluginDirectory;
    final JarFile[] jars;

    PluginClassLoader(ClassLoader parent, File pluginDirectory) throws IOException {
        super(parent);
        if (pluginDirectory == null) {
            throw new NullPointerException();
        }
        this.pluginDirectory = pluginDirectory;
        File[] jarFiles = pluginDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        this.jars = new JarFile[jarFiles.length];
        for (int i = 0; i < this.jars.length; ++i) {
            this.jars[i] = new JarFile(jarFiles[i]);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String classFileName = name.replace('.', '/') + ".class";
        for (JarFile jar : this.jars) {
            JarEntry je = jar.getJarEntry(classFileName);
            if (je == null) continue;
            byte[] classData = this.readClassFile(jar, je, classFileName);
            return this.defineClass(name, classData, 0, classData.length);
        }
        throw new ClassNotFoundException(name);
    }

    byte[] readClassFile(JarFile jar, JarEntry je, String classFileName) {
        byte[] buf = new byte[(int)je.getSize()];
        if (buf.length == 0) {
            throw new RuntimeException("Class file is length zero. (" + classFileName + " in " + jar.getName() + ")");
        }
        InputStream is = null;
        try {
            is = jar.getInputStream(je);
            int readSize = 0;
            for (int offset = 0; offset < buf.length; offset += readSize) {
                readSize = is.read(buf, offset, buf.length - offset);
                if (readSize != -1) continue;
                throw new RuntimeException("Unexpected EOF. (" + classFileName + " in " + jar.getName() + ")");
            }
            byte[] byArray = buf;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Class file read error. (" + classFileName + " in " + jar.getName() + ")", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

