package person;

import org.jdesktop.beansbinding.Validator;

public class RequiredValidator extends Validator<Object> {
    public enum ErrorCode {
        NULL_VALUE, LENGTH_ZERO
    }

    public final Validator.Result NULL_VALUE
        = new Validator.Result(ErrorCode.NULL_VALUE, "Null is not permitted.");
    public final Validator.Result LENGTH_ZERO
        = new Validator.Result(ErrorCode.LENGTH_ZERO, "Length zero.");

    @Override public Validator.Result validate(Object value) {
        if (value == null) return NULL_VALUE;
        if (value instanceof CharSequence &&
            ((CharSequence)value).length() == 0) return LENGTH_ZERO;
        return null;
    }
}
