package person;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class Person implements Serializable {
    private static final long serialVersionUID = 6522075927845542296L;
    String name;
    public static final String PROP_NAME = "name";

    /**
     * Get the value of name
     *
     * @return the value of name
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the value of name
     *
     * @param newname new value of name
     */
    public void setName(String newname) {
        String oldname = name;
        this.name = newname;
        propertyChangeSupport.firePropertyChange(PROP_NAME, oldname, newname);
    }
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    /**
     * Add PropertyChangeListener.
     *
     * @param listener
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.addPropertyChangeListener(listener);
    }

    /**
     * Remove PropertyChangeListener.
     *
     * @param listener
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.removePropertyChangeListener(listener);
    }

        int age;
    public static final String PROP_AGE = "age";

    /**
     * Get the value of age
     *
     * @return the value of age
     */
    public int getAge() {
        return this.age;
    }

    /**
     * Set the value of age
     *
     * @param newage new value of age
     */
    public void setAge(int newage) {
        int oldage = age;
        this.age = newage;
        propertyChangeSupport.firePropertyChange(PROP_AGE, oldage, newage);
    }

}
