/*
 * Decompiled with CFR 0.152.
 */
package com.ruimo.gui;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class ModelUndoableEdit
extends AbstractUndoableEdit {
    final Object model;
    final PropertyDescriptor propertyDescriptor;
    Object oldValue;
    Object newValue;
    boolean replaced;
    static Map<String, PropertyDescriptor> propDescTable;

    static void ensurePropertyTable(Object model) {
        if (propDescTable == null) {
            propDescTable = new HashMap<String, PropertyDescriptor>();
            try {
                BeanInfo bi = Introspector.getBeanInfo(model.getClass());
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    propDescTable.put(pd.getName(), pd);
                }
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public ModelUndoableEdit(PropertyChangeEvent ev) {
        this.model = ev.getSource();
        if (this.model == null) {
            throw new NullPointerException("model is null.");
        }
        ModelUndoableEdit.ensurePropertyTable(this.model);
        this.propertyDescriptor = propDescTable.get(ev.getPropertyName());
        this.oldValue = ev.getOldValue();
        this.newValue = ev.getNewValue();
    }

    static CannotUndoException cannotUndo(Throwable t) {
        return (CannotUndoException)new CannotUndoException().initCause(t);
    }

    static CannotRedoException cannotRedo(Throwable t) {
        return (CannotRedoException)new CannotRedoException().initCause(t);
    }

    public void undo() throws CannotUndoException {
        if (this.replaced) {
            throw new CannotUndoException();
        }
        try {
            this.propertyDescriptor.getWriteMethod().invoke(this.model, this.oldValue);
        }
        catch (IllegalAccessException ex) {
            throw ModelUndoableEdit.cannotUndo(ex);
        }
        catch (IllegalArgumentException ex) {
            throw ModelUndoableEdit.cannotUndo(ex);
        }
        catch (InvocationTargetException ex) {
            throw ModelUndoableEdit.cannotUndo(ex);
        }
    }

    public void redo() throws CannotRedoException {
        if (this.replaced) {
            throw new CannotRedoException();
        }
        try {
            this.propertyDescriptor.getWriteMethod().invoke(this.model, this.newValue);
        }
        catch (IllegalAccessException ex) {
            throw ModelUndoableEdit.cannotUndo(ex);
        }
        catch (IllegalArgumentException ex) {
            throw ModelUndoableEdit.cannotUndo(ex);
        }
        catch (InvocationTargetException ex) {
            throw ModelUndoableEdit.cannotUndo(ex);
        }
    }

    public boolean replaceEdit(UndoableEdit olderEdit) {
        if (olderEdit.getClass() != this.getClass()) {
            return false;
        }
        ModelUndoableEdit mue = (ModelUndoableEdit)olderEdit;
        if (!mue.propertyDescriptor.getName().equals(this.propertyDescriptor.getName())) {
            return false;
        }
        this.oldValue = mue.oldValue;
        mue.replaced = true;
        return true;
    }

    public boolean canRedo() {
        return !this.replaced;
    }

    public boolean canUndo() {
        return !this.replaced;
    }
}

