/*
 * Decompiled with CFR 0.152.
 */
package com.ruimo.gui;

import com.ruimo.gui.DefaultModelUndoableEditFactory;
import com.ruimo.gui.ModelLifeCycleContext;
import com.ruimo.gui.ModelUndoableEditFactory;
import com.ruimo.gui.YesNoCancelResponse;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.undo.UndoManager;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelLifeCycleManager<T>
implements Serializable {
    UndoManager undoManager = new UndoManager();
    private State state;
    private PropertyChangeSupport propertySupport;
    File editingFile;
    public static final String PROP_EDITINGFILE = "editingFile";
    ModelUndoableEditFactory modelUndoableEditFactory = new DefaultModelUndoableEditFactory();
    Class<T> modelClass;
    ModelLifeCycleContext<T> context;
    boolean newModelMenuEnabled;
    public static final String PROP_NEWMODELMENUENABLED = "newModelMenuEnabled";
    boolean openModelMenuEnabled;
    public static final String PROP_OPENMODELMENUENABLED = "openModelMenuEnabled";
    protected boolean saveModelMenuEnabled;
    public static final String PROP_SAVEMODELMENUENABLED = "saveModelMenuEnabled";
    boolean saveModelAsMenuEnabled;
    public static final String PROP_SAVEMODELASMENUENABLED = "saveModelAsMenuEnabled";
    boolean closeModelMenuEnabled;
    public static final String PROP_CLOSEMODELMENUENABLED = "closeModelMenuEnabled";
    T model;
    boolean undoPossible;
    public static final String PROP_UNDOPOSSIBLE = "undoPossible";
    boolean redoPossible;
    public static final String PROP_REDOPOSSIBLE = "redoPossible";
    String undoPresentationName;
    public static final String PROP_UNDOPRESENTATIONNAME = "undoPresentationName";
    String redoPresentationName;
    public static final String PROP_REDOPRESENTATIONNAME = "redoPresentationName";
    boolean undoing;
    boolean redoing;

    private void changeState(State newState) {
        switch (newState) {
            case FILE_DIRTY: {
                this.setNewModelMenuEnabled(true);
                this.setOpenModelMenuEnabled(true);
                this.setSaveModelMenuEnabled(true);
                this.setSaveModelAsMenuEnabled(true);
                this.setCloseModelMenuEnabled(true);
                break;
            }
            case FILE_CLEAN: 
            case NEW_DIRTY: {
                this.setNewModelMenuEnabled(true);
                this.setOpenModelMenuEnabled(true);
                this.setSaveModelMenuEnabled(false);
                this.setSaveModelAsMenuEnabled(true);
                this.setCloseModelMenuEnabled(true);
                break;
            }
            case NEW_CLEAN: {
                this.setNewModelMenuEnabled(false);
                this.setOpenModelMenuEnabled(true);
                this.setSaveModelMenuEnabled(false);
                this.setSaveModelAsMenuEnabled(true);
                this.setCloseModelMenuEnabled(false);
            }
        }
        this.state = newState;
    }

    public ModelLifeCycleManager() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public File getEditingFile() {
        return this.editingFile;
    }

    public void setEditingFile(File neweditingFile) {
        File oldeditingFile = this.editingFile;
        this.editingFile = neweditingFile;
        this.propertySupport.firePropertyChange(PROP_EDITINGFILE, oldeditingFile, neweditingFile);
    }

    public void setModelUndoableEditFactory(ModelUndoableEditFactory modelUndoableEditFactory) {
        if (this.modelClass != null) {
            throw new IllegalStateException("You need to call this method before you call the start() method.");
        }
        if (modelUndoableEditFactory == null) {
            throw new NullPointerException();
        }
        this.modelUndoableEditFactory = modelUndoableEditFactory;
    }

    public void start(Class<T> modelClass, ModelLifeCycleContext<T> context) {
        if (modelClass == null) {
            throw new NullPointerException("modelClass is null.");
        }
        if (context == null) {
            throw new NullPointerException("context is null.");
        }
        if (this.modelClass != null) {
            throw new IllegalStateException("Do not call start() more than once.");
        }
        this.modelClass = modelClass;
        this.context = context;
        this.createModel();
        this.changeState(State.NEW_CLEAN);
        this.updateUndoMenu();
    }

    public boolean isNewModelMenuEnabled() {
        return this.newModelMenuEnabled;
    }

    public void setNewModelMenuEnabled(boolean newnewModelMenuEnabled) {
        boolean oldnewModelMenuEnabled = this.newModelMenuEnabled;
        this.newModelMenuEnabled = newnewModelMenuEnabled;
        this.propertySupport.firePropertyChange(PROP_NEWMODELMENUENABLED, oldnewModelMenuEnabled, newnewModelMenuEnabled);
    }

    public boolean isOpenModelMenuEnabled() {
        return this.openModelMenuEnabled;
    }

    public void setOpenModelMenuEnabled(boolean newopenModelMenuEnabled) {
        boolean oldopenModelMenuEnabled = this.openModelMenuEnabled;
        this.openModelMenuEnabled = newopenModelMenuEnabled;
        this.propertySupport.firePropertyChange(PROP_OPENMODELMENUENABLED, oldopenModelMenuEnabled, newopenModelMenuEnabled);
    }

    public boolean isSaveModelMenuEnabled() {
        return this.saveModelMenuEnabled;
    }

    public void setSaveModelMenuEnabled(boolean newsaveModelMenuEnabled) {
        boolean oldsaveModelMenuEnabled = this.saveModelMenuEnabled;
        this.saveModelMenuEnabled = newsaveModelMenuEnabled;
        this.propertySupport.firePropertyChange(PROP_SAVEMODELMENUENABLED, oldsaveModelMenuEnabled, newsaveModelMenuEnabled);
    }

    public boolean isSaveModelAsMenuEnabled() {
        return this.saveModelAsMenuEnabled;
    }

    public void setSaveModelAsMenuEnabled(boolean newsaveModelAsMenuEnabled) {
        boolean oldsaveModelAsMenuEnabled = this.saveModelAsMenuEnabled;
        this.saveModelAsMenuEnabled = newsaveModelAsMenuEnabled;
        this.propertySupport.firePropertyChange(PROP_SAVEMODELASMENUENABLED, oldsaveModelAsMenuEnabled, newsaveModelAsMenuEnabled);
    }

    public boolean isCloseModelMenuEnabled() {
        return this.closeModelMenuEnabled;
    }

    public void setCloseModelMenuEnabled(boolean newcloseModelMenuEnabled) {
        boolean oldcloseModelMenuEnabled = this.closeModelMenuEnabled;
        this.closeModelMenuEnabled = newcloseModelMenuEnabled;
        this.propertySupport.firePropertyChange(PROP_CLOSEMODELMENUENABLED, oldcloseModelMenuEnabled, newcloseModelMenuEnabled);
    }

    public T getModel() {
        return this.model;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    void createModel() {
        T newModel = null;
        try {
            newModel = this.modelClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        this.context.setInitialValue(newModel);
        if (this.model != null) {
            this.swapModel(newModel, null);
        } else {
            this.model = newModel;
            BeanInfo bi = this.getBeanInfo(newModel);
            for (EventSetDescriptor esd : bi.getEventSetDescriptors()) {
                if (esd.getListenerType() != PropertyChangeListener.class) continue;
                Method m = esd.getAddListenerMethod();
                try {
                    m.invoke(this.model, new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            ModelLifeCycleManager.this.invalidate();
                            if (!ModelLifeCycleManager.this.undoing && !ModelLifeCycleManager.this.redoing) {
                                ModelLifeCycleManager.this.undoManager.addEdit(ModelLifeCycleManager.this.modelUndoableEditFactory.createInstance(evt));
                                ModelLifeCycleManager.this.updateUndoMenu();
                            }
                        }
                    });
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    void updateUndoMenu() {
        this.setUndoPossible(this.undoManager.canUndo());
        this.setRedoPossible(this.undoManager.canRedo());
        this.setUndoPresentationName(this.undoManager.getUndoPresentationName());
        this.setRedoPresentationName(this.undoManager.getRedoPresentationName());
    }

    BeanInfo getBeanInfo(T m) {
        try {
            return Introspector.getBeanInfo(m.getClass());
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
    }

    void swapModel(T newModel, BindingGroup bindingGroup) {
        if (bindingGroup != null) {
            this.model = newModel;
            for (Binding b : bindingGroup.getBindings()) {
                if (b.getSourceObject() != this) continue;
                b.unbind();
                b.bind();
            }
        } else {
            PropertyDescriptor[] pdtable;
            BeanInfo bi = this.getBeanInfo(newModel);
            for (PropertyDescriptor pd : pdtable = bi.getPropertyDescriptors()) {
                if (!pd.isBound()) continue;
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                if (getter == null || setter == null) continue;
                try {
                    Object prop = getter.invoke(newModel, new Object[0]);
                    setter.invoke(this.model, prop);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    boolean saveCurrentModelWithQuery(BindingGroup bindingGroup) {
        YesNoCancelResponse resp = this.context.querySaveCurrentModel();
        if (resp == YesNoCancelResponse.CANCEL) {
            return false;
        }
        if (resp == YesNoCancelResponse.YES) {
            return this.saveCurrentModel(bindingGroup);
        }
        return true;
    }

    File querySaveFile() {
        File file = null;
        file = this.context.querySaveFile();
        if (file == null) {
            return null;
        }
        if (file.exists()) {
            YesNoCancelResponse resp = this.context.queryOverwrite(file);
            if (resp == YesNoCancelResponse.CANCEL) {
                return null;
            }
            if (resp != YesNoCancelResponse.YES) {
                // empty if block
            }
        }
        return file;
    }

    boolean saveCurrentModel(BindingGroup bindingGroup) {
        if (!this.context.isModelValid(bindingGroup)) {
            return false;
        }
        if (this.editingFile == null) {
            File file = this.querySaveFile();
            if (file == null) {
                return false;
            }
            if (!this.context.saveModel(file, this.model)) {
                return false;
            }
            this.setEditingFile(file);
        } else if (!this.context.saveModel(this.editingFile, this.model)) {
            return false;
        }
        return true;
    }

    public void invalidate() {
        switch (this.state) {
            case FILE_DIRTY: 
            case NEW_DIRTY: {
                break;
            }
            case FILE_CLEAN: {
                this.changeState(State.FILE_DIRTY);
                break;
            }
            case NEW_CLEAN: {
                this.changeState(State.NEW_DIRTY);
            }
        }
    }

    public void validate() {
        switch (this.state) {
            case FILE_DIRTY: {
                this.changeState(State.FILE_CLEAN);
                break;
            }
            case NEW_DIRTY: {
                this.changeState(State.NEW_CLEAN);
                break;
            }
        }
    }

    public void invokeNewModel(BindingGroup bindingGroup) {
        if (this.modelClass == null) {
            throw new IllegalStateException("call start() method first.");
        }
        switch (this.state) {
            case FILE_DIRTY: 
            case NEW_DIRTY: {
                if (!this.saveCurrentModelWithQuery(bindingGroup)) {
                    return;
                }
            }
            case FILE_CLEAN: 
            case NEW_CLEAN: {
                this.createModel();
                this.setEditingFile(null);
                this.changeState(State.NEW_CLEAN);
            }
        }
    }

    public void invokeOpenModel(BindingGroup bindingGroup) {
        if (this.modelClass == null) {
            throw new IllegalStateException("call start() method first.");
        }
        switch (this.state) {
            case FILE_DIRTY: 
            case NEW_DIRTY: {
                if (!this.saveCurrentModelWithQuery(bindingGroup)) {
                    return;
                }
            }
            case FILE_CLEAN: 
            case NEW_CLEAN: {
                File openFile = this.context.queryOpenFile();
                if (openFile == null) {
                    return;
                }
                T newModel = this.context.loadModel(openFile);
                if (newModel == null) {
                    return;
                }
                this.swapModel(newModel, bindingGroup);
                this.changeState(State.FILE_CLEAN);
            }
        }
    }

    public void invokeSaveModel(BindingGroup bindingGroup) {
        if (this.modelClass == null) {
            throw new IllegalStateException("call start() method first.");
        }
        switch (this.state) {
            case FILE_DIRTY: {
                if (!this.saveCurrentModel(bindingGroup)) {
                    return;
                }
                this.changeState(State.FILE_CLEAN);
                break;
            }
            case FILE_CLEAN: 
            case NEW_DIRTY: 
            case NEW_CLEAN: {
                throw new IllegalStateException("logic error. current state:" + (Object)((Object)this.state));
            }
        }
    }

    public void invokeSaveAsModel(BindingGroup bindingGroup) {
        if (this.modelClass == null) {
            throw new IllegalStateException("call start() method first.");
        }
        if (!this.context.isModelValid(bindingGroup)) {
            return;
        }
        File file = this.querySaveFile();
        if (file == null) {
            return;
        }
        if (!this.context.saveModel(file, this.model)) {
            return;
        }
        this.editingFile = file;
        this.changeState(State.FILE_CLEAN);
    }

    public boolean invokeCloseModel(BindingGroup bindingGroup) {
        if (this.modelClass == null) {
            throw new IllegalStateException("call start() method first.");
        }
        switch (this.state) {
            case FILE_DIRTY: 
            case NEW_DIRTY: {
                YesNoCancelResponse resp = this.context.querySaveCurrentModel();
                if (resp == YesNoCancelResponse.CANCEL) {
                    return false;
                }
                if (resp == YesNoCancelResponse.YES && !this.saveCurrentModel(bindingGroup)) {
                    return false;
                }
            }
            case FILE_CLEAN: {
                this.createModel();
                this.setEditingFile(null);
                break;
            }
        }
        return true;
    }

    public boolean isUndoPossible() {
        return this.undoPossible;
    }

    void setUndoPossible(boolean newundoPossible) {
        boolean oldundoPossible = this.undoPossible;
        this.undoPossible = newundoPossible;
        this.propertySupport.firePropertyChange(PROP_UNDOPOSSIBLE, oldundoPossible, newundoPossible);
    }

    public boolean isRedoPossible() {
        return this.redoPossible;
    }

    void setRedoPossible(boolean newredoPossible) {
        boolean oldredoPossible = this.redoPossible;
        this.redoPossible = newredoPossible;
        this.propertySupport.firePropertyChange(PROP_REDOPOSSIBLE, oldredoPossible, newredoPossible);
    }

    public String getUndoPresentationName() {
        return this.undoPresentationName;
    }

    void setUndoPresentationName(String newundoPresentationName) {
        String oldundoPresentationName = this.undoPresentationName;
        this.undoPresentationName = newundoPresentationName;
        this.propertySupport.firePropertyChange(PROP_UNDOPRESENTATIONNAME, oldundoPresentationName, newundoPresentationName);
    }

    public String getRedoPresentationName() {
        return this.redoPresentationName;
    }

    void setRedoPresentationName(String newredoPresentationName) {
        String oldredoPresentationName = this.redoPresentationName;
        this.redoPresentationName = newredoPresentationName;
        this.propertySupport.firePropertyChange(PROP_REDOPRESENTATIONNAME, oldredoPresentationName, newredoPresentationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        try {
            this.undoing = true;
            this.undoManager.undo();
            this.updateUndoMenu();
        }
        finally {
            this.undoing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        try {
            this.redoing = true;
            this.undoManager.redo();
            this.updateUndoMenu();
        }
        finally {
            this.redoing = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        FILE_DIRTY,
        FILE_CLEAN,
        NEW_DIRTY,
        NEW_CLEAN;

    }
}

