/*
 * Decompiled with CFR 0.152.
 */
package com.ruimo.gui;

import com.ruimo.gui.ModelLifeCycleContext;
import com.ruimo.gui.YesNoCancelResponse;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleModelLifeCycleContext<T>
implements ModelLifeCycleContext<T> {
    protected final Component parent;
    final String saveQueryTitle;
    final String saveQueryMessage;
    final Icon saveQueryIcon;
    final String queryOverwriteTitle;
    final String queryOverwriteMessage;
    final Icon queryOverwriteIcon;
    final String fixErrorTitle;
    final String fixErrorMessage;
    final Icon fixErrorIcon;
    final String fileSaveErrorTitle;
    final String fileSaveErrorMessage;
    final Icon fileSaveErrorIcon;
    final String fileOpenErrorTitle;
    final String fileOpenErrorMessage;
    final Icon fileOpenErrorIcon;
    final JFileChooser querySaveFileChooser;
    final JFileChooser queryOpenFileChooser;
    JOptionPane querySaveCurrentModelDialog;

    public SimpleModelLifeCycleContext(Component parent, String saveQueryTitle, String saveQueryMessage, Icon saveQueryIcon, String queryOverwriteTitle, String queryOverwriteMessage, Icon queryOverwriteIcon, String fixErrorTitle, String fixErrorMessage, Icon fixErrorIcon, String fileSaveErrorTitle, String fileSaveErrorMessage, Icon fileSaveErrorIcon, String fileOpenErrorTitle, String fileOpenErrorMessage, Icon fileOpenErrorIcon, JFileChooser querySaveFileChooser, JFileChooser queryOpenFileChooser) {
        if (saveQueryMessage == null) {
            throw new NullPointerException("saveQueryMessage is null.");
        }
        if (saveQueryTitle == null) {
            saveQueryTitle = saveQueryMessage;
        }
        if (queryOverwriteMessage == null) {
            throw new NullPointerException("queryOverwriteMessage is null.");
        }
        if (queryOverwriteTitle == null) {
            queryOverwriteTitle = queryOverwriteMessage;
        }
        if (fixErrorTitle == null) {
            fixErrorTitle = fixErrorMessage;
        }
        if (fileSaveErrorMessage == null) {
            throw new NullPointerException("fileSaveErrorMessage is null.");
        }
        if (fileSaveErrorTitle == null) {
            fileSaveErrorTitle = fileSaveErrorMessage;
        }
        if (fileOpenErrorMessage == null) {
            throw new NullPointerException("fileOpenErrorMessage is null.");
        }
        if (fileOpenErrorTitle == null) {
            fileOpenErrorTitle = fileOpenErrorMessage;
        }
        this.saveQueryTitle = saveQueryTitle;
        this.saveQueryMessage = saveQueryMessage;
        this.queryOverwriteTitle = queryOverwriteTitle;
        this.queryOverwriteMessage = queryOverwriteMessage;
        this.fixErrorTitle = fixErrorTitle;
        this.fixErrorMessage = fixErrorMessage;
        this.fileSaveErrorTitle = fileSaveErrorTitle;
        this.fileSaveErrorMessage = fileSaveErrorMessage;
        this.fileOpenErrorTitle = fileOpenErrorTitle;
        this.fileOpenErrorMessage = fileOpenErrorMessage;
        if (querySaveFileChooser == null) {
            querySaveFileChooser = new JFileChooser();
        }
        this.querySaveFileChooser = querySaveFileChooser;
        if (queryOpenFileChooser == null) {
            queryOpenFileChooser = new JFileChooser();
        }
        this.queryOpenFileChooser = queryOpenFileChooser;
        this.parent = parent;
        this.saveQueryIcon = saveQueryIcon;
        this.queryOverwriteIcon = queryOverwriteIcon;
        this.fixErrorIcon = fixErrorIcon;
        this.fileSaveErrorIcon = fileSaveErrorIcon;
        this.fileOpenErrorIcon = fileOpenErrorIcon;
    }

    @Override
    public YesNoCancelResponse querySaveCurrentModel() {
        int resp = JOptionPane.showConfirmDialog(this.parent, this.saveQueryMessage, this.saveQueryTitle, 1, 3, this.saveQueryIcon);
        switch (resp) {
            case 0: {
                return YesNoCancelResponse.YES;
            }
            case 1: {
                return YesNoCancelResponse.NO;
            }
            case 2: {
                return YesNoCancelResponse.CANCEL;
            }
        }
        throw new RuntimeException("Logic error.");
    }

    @Override
    public File querySaveFile() {
        int resp = this.querySaveFileChooser.showSaveDialog(this.parent);
        if (resp == 0) {
            return this.querySaveFileChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    public File queryOpenFile() {
        int resp = this.queryOpenFileChooser.showOpenDialog(this.parent);
        if (resp == 0) {
            return this.queryOpenFileChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    public YesNoCancelResponse queryOverwrite(File file) {
        int resp = JOptionPane.showConfirmDialog(this.parent, String.format(this.queryOverwriteMessage, file.getAbsolutePath()), this.queryOverwriteTitle, 1, 3, this.queryOverwriteIcon);
        switch (resp) {
            case 0: {
                return YesNoCancelResponse.YES;
            }
            case 1: {
                return YesNoCancelResponse.NO;
            }
            case 2: {
                return YesNoCancelResponse.CANCEL;
            }
        }
        throw new RuntimeException("Unknown response: " + resp);
    }

    @Override
    public boolean isModelValid(BindingGroup bindingGroup) {
        for (Binding b : bindingGroup.getBindings()) {
            Binding.SyncFailureType type;
            Binding.ValueResult vr = b.getTargetValueForSource();
            if (!vr.failed() || (type = vr.getFailure().getType()) != Binding.SyncFailureType.CONVERSION_FAILED && type != Binding.SyncFailureType.VALIDATION_FAILED) continue;
            JOptionPane.showMessageDialog(this.parent, this.fixErrorMessage, this.fixErrorTitle, 0, this.fixErrorIcon);
            return false;
        }
        return true;
    }

    @Override
    public void setInitialValue(T model) {
    }

    protected void showFileError(File file, String title, String message, Throwable cause, Icon icon) {
        String causeMessage = "";
        if (cause != null) {
            causeMessage = cause.getMessage();
        }
        JOptionPane.showMessageDialog(this.parent, String.format(message, file.getAbsolutePath(), causeMessage), String.format(title, file.getAbsolutePath(), causeMessage), 0, icon);
    }

    protected void showFileSaveError(File file, Throwable cause) {
        this.showFileError(file, this.fileSaveErrorTitle, this.fileSaveErrorMessage, cause, this.fileSaveErrorIcon);
    }

    protected void showFileOpenError(File file, Throwable cause) {
        this.showFileError(file, this.fileOpenErrorTitle, this.fileOpenErrorMessage, cause, this.fileOpenErrorIcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveModel(File file, T model) {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            oos.writeObject(model);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            this.showFileSaveError(file, ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {
                    this.showFileSaveError(file, ex);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T loadModel(File file) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object object = ois.readObject();
            return (T)object;
        }
        catch (IOException ex) {
            this.showFileOpenError(file, ex);
        }
        catch (ClassNotFoundException ex) {
            this.showFileOpenError(file, ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return null;
    }
}

