/*
 * Decompiled with CFR 0.152.
 */
package person;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.beansbinding.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMaxValidator<T extends Number>
extends Validator<T> {
    T min;
    T max;
    static final Map<Class<? extends Number>, Comparator<? extends Number>> comparatorTable = new HashMap<Class<? extends Number>, Comparator<? extends Number>>();
    public final Validator.Result BELOW_MIN = new Validator.Result((Validator)this, (Object)ErrorCode.BELOW_MIN, "Value is less than minimum value.");
    public final Validator.Result ABOVE_MAX = new Validator.Result((Validator)this, (Object)ErrorCode.ABOVE_MAX, "Value exceeds maximum value.");

    public void setMin(T min) {
        this.min = min;
    }

    public T getMin() {
        return this.min;
    }

    public void setMax(T max) {
        this.max = max;
    }

    public T getMax() {
        return this.max;
    }

    public Validator.Result validate(T value) {
        if (value == null) {
            return null;
        }
        Comparator<? extends Number> cmp = comparatorTable.get(value.getClass());
        if (cmp == null) {
            throw new RuntimeException("Unsupported type:" + value.getClass());
        }
        if (cmp.compare((Number)value, (Number)this.min) < 0) {
            return this.BELOW_MIN;
        }
        if (cmp.compare((Number)this.max, (Number)value) < 0) {
            return this.ABOVE_MAX;
        }
        return null;
    }

    static {
        comparatorTable.put(Byte.class, (Comparator<? extends Number>)new Comparator<Byte>(){

            @Override
            public int compare(Byte b1, Byte b2) {
                return b1.compareTo(b2);
            }
        });
        comparatorTable.put(Integer.class, (Comparator<? extends Number>)new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return i1.compareTo(i2);
            }
        });
        comparatorTable.put(Double.class, (Comparator<? extends Number>)new Comparator<Double>(){

            @Override
            public int compare(Double d1, Double d2) {
                return d1.compareTo(d2);
            }
        });
        comparatorTable.put(Float.class, (Comparator<? extends Number>)new Comparator<Float>(){

            @Override
            public int compare(Float f1, Float f2) {
                return f1.compareTo(f2);
            }
        });
        comparatorTable.put(Long.class, (Comparator<? extends Number>)new Comparator<Long>(){

            @Override
            public int compare(Long l1, Long l2) {
                return l1.compareTo(l2);
            }
        });
        comparatorTable.put(Short.class, (Comparator<? extends Number>)new Comparator<Short>(){

            @Override
            public int compare(Short s1, Short s2) {
                return s1.compareTo(s2);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorCode {
        BELOW_MIN,
        ABOVE_MAX;

    }
}

