/*
 * PersonView.java
 */

package person;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.application.Application;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Binding.SyncFailure;
import org.jdesktop.beansbinding.Binding.SyncFailureType;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.Validator;

/**
 * The application's main frame.
 */
public class PersonView extends FrameView {

    public PersonView(SingleFrameApplication app) {
        super(app);

        initComponents();
        setInitialValue();
        bindingGroup.addBindingListener(new BindingChecker());
        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        statusAnimationLabel.setIcon(idleIcon);
        progressBar.setVisible(false);

        // connecting action tasks to status bar via TaskMonitor
        TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!busyIconTimer.isRunning()) {
                        statusAnimationLabel.setIcon(busyIcons[0]);
                        busyIconIndex = 0;
                        busyIconTimer.start();
                    }
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    busyIconTimer.stop();
                    statusAnimationLabel.setIcon(idleIcon);
                    progressBar.setVisible(false);
                    progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)(evt.getNewValue());
                    statusMessageLabel.setText((text == null) ? "" : text);
                    messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)(evt.getNewValue());
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(false);
                    progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = getFrame();
            aboutBox = new PersonAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        PersonApp.getApplication().show(aboutBox);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        mainPanel = new javax.swing.JPanel();
        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        ageLabel = new javax.swing.JLabel();
        ageTextField = new javax.swing.JTextField();
        nameErrorLabel = new javax.swing.JLabel();
        ageErrorLabel = new javax.swing.JLabel();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        openMenuItem = new javax.swing.JMenuItem();
        saveMenuItem = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();
        person = new person.Person();
        nameValidator = new person.RequiredValidator();

        mainPanel.setName("mainPanel"); // NOI18N

        nameLabel.setDisplayedMnemonic('N');
        nameLabel.setLabelFor(nameTextField);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(person.PersonApp.class).getContext().getResourceMap(PersonView.class);
        nameLabel.setText(resourceMap.getString("nameLabel.text")); // NOI18N
        nameLabel.setName("nameLabel"); // NOI18N

        nameTextField.setName("nameTextField"); // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, person, org.jdesktop.beansbinding.ELProperty.create("${name}"), nameTextField, org.jdesktop.beansbinding.BeanProperty.create("text"), "person.name");
        binding.setValidator(nameValidator);
        bindingGroup.addBinding(binding);

        ageLabel.setDisplayedMnemonic('A');
        ageLabel.setLabelFor(ageTextField);
        ageLabel.setText(resourceMap.getString("ageLabel.text")); // NOI18N
        ageLabel.setName("ageLabel"); // NOI18N

        ageTextField.setName("ageTextField"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, person, org.jdesktop.beansbinding.ELProperty.create("${age}"), ageTextField, org.jdesktop.beansbinding.BeanProperty.create("text"), "person.age");
        bindingGroup.addBinding(binding);

        nameErrorLabel.setFont(resourceMap.getFont("ageErrorLabel.font")); // NOI18N
        nameErrorLabel.setForeground(resourceMap.getColor("ageErrorLabel.foreground")); // NOI18N
        nameErrorLabel.setText(resourceMap.getString("nameErrorLabel.text")); // NOI18N
        nameErrorLabel.setName("nameErrorLabel"); // NOI18N

        ageErrorLabel.setFont(resourceMap.getFont("ageErrorLabel.font")); // NOI18N
        ageErrorLabel.setForeground(resourceMap.getColor("ageErrorLabel.foreground")); // NOI18N
        ageErrorLabel.setText(resourceMap.getString("ageErrorLabel.text")); // NOI18N
        ageErrorLabel.setName("ageErrorLabel"); // NOI18N

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(nameLabel)
                    .addComponent(ageLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(ageTextField)
                    .addComponent(nameTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 119, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(ageErrorLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE)
                    .addComponent(nameErrorLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE))
                .addContainerGap())
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(nameLabel)
                    .addComponent(nameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(nameErrorLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(ageLabel)
                    .addComponent(ageTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ageErrorLabel))
                .addContainerGap(162, Short.MAX_VALUE))
        );

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(person.PersonApp.class).getContext().getActionMap(PersonView.class, this);
        openMenuItem.setAction(actionMap.get("openPersonFile")); // NOI18N
        openMenuItem.setMnemonic('O');
        openMenuItem.setName("openMenuItem"); // NOI18N
        fileMenu.add(openMenuItem);

        saveMenuItem.setAction(actionMap.get("savePersonFile")); // NOI18N
        saveMenuItem.setMnemonic('S');
        saveMenuItem.setName("saveMenuItem"); // NOI18N
        fileMenu.add(saveMenuItem);

        jSeparator1.setName("jSeparator1"); // NOI18N
        fileMenu.add(jSeparator1);

        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setMnemonic('X');
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        statusPanel.setName("statusPanel"); // NOI18N

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        progressBar.setName("progressBar"); // NOI18N

        javax.swing.GroupLayout statusPanelLayout = new javax.swing.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(statusPanelSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(statusMessageLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 214, Short.MAX_VALUE)
                .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(statusAnimationLabel)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addComponent(statusPanelSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 2, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(statusMessageLabel)
                    .addComponent(statusAnimationLabel)
                    .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(3, 3, 3))
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents

    @Action
    public void openPersonFile() {
        JFrame parent = getFrame();
        if (fileChooser.showOpenDialog(parent) != JFileChooser.APPROVE_OPTION) return;
        File file = fileChooser.getSelectedFile();
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream
                (new BufferedInputStream(new FileInputStream(file)));
            storePerson((Person)ois.readObject());
        }
        catch(IOException ex) {
            fileError(file, "file.open.error", ex);
        }
        catch (ClassNotFoundException ex) {
            fileError(file, "file.open.error", ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(PersonView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Action
    public void savePersonFile() {
        JFrame parent = getFrame();
        for (Binding b: bindingGroup.getBindings()) {
            if (b.getTargetValueForSource().failed()) {
                ResourceMap resourceMap = Application.getInstance
                    (PersonApp.class).getContext().getResourceMap(PersonView.class);
                JOptionPane.showMessageDialog
                    (parent, resourceMap.getString("fix.error"));
                return;
            }
        }
        if (fileChooser.showSaveDialog(parent) != JFileChooser.APPROVE_OPTION) return;
        File file = fileChooser.getSelectedFile();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream
                (new BufferedOutputStream(new FileOutputStream(file)));
            oos.writeObject(person);
        }
        catch (IOException ex) {
            fileError(file, "file.save.error", ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {
                    fileError(file, "file.save.error", ex);
                }
            }
        }
    }

    void fileError(File file, String messageKey, Throwable cause) {
        JFrame parent = getFrame();
        ResourceMap resourceMap = Application.getInstance
            (PersonApp.class).getContext().getResourceMap(PersonView.class);

        JOptionPane.showMessageDialog
            (parent,
             String.format(resourceMap.getString(messageKey),
                           file.getAbsolutePath()));
        Logger.getLogger(PersonView.class.getName()).log(Level.SEVERE, null, cause);
    }

    JFileChooser fileChooser = new JFileChooser();
    {
        fileChooser.setMultiSelectionEnabled(false);
    }

    void storePerson(Person newPerson) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(person.getClass());
            for (PropertyDescriptor pd: bi.getPropertyDescriptors()) {
                if (pd.isBound()) {
                    Method reader = pd.getReadMethod();
                    Method writer = pd.getWriteMethod();
                    if (reader != null && writer != null) {
                        writer.invoke(person, reader.invoke(newPerson));
                    }
                }
            }
        }
        catch (IntrospectionException ex) {throw new RuntimeException(ex);}
        catch (IllegalAccessException ex) {throw new RuntimeException(ex);}
        catch (IllegalArgumentException ex) {throw new RuntimeException(ex);}
        catch (InvocationTargetException ex) {throw new RuntimeException(ex);}
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel ageErrorLabel;
    private javax.swing.JLabel ageLabel;
    private javax.swing.JTextField ageTextField;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JLabel nameErrorLabel;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameTextField;
    private person.RequiredValidator nameValidator;
    private javax.swing.JMenuItem openMenuItem;
    private person.Person person;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JMenuItem saveMenuItem;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;

    private JDialog aboutBox;

    void setInitialValue() {
        ResourceMap resourceMap = Application.getInstance
            (PersonApp.class).getContext().getResourceMap(PersonView.class);
        nameTextField.setText(resourceMap.getString("name.default"));
        ageTextField.setText(resourceMap.getString("age.default"));
    }

    class BindingChecker implements BindingListener {
        public void bindingBecameBound(Binding binding) {}
        public void bindingBecameUnbound(Binding binding) {}

        public void syncFailed(Binding binding, SyncFailure failure) {
            ResourceMap resourceMap = Application.getInstance
                (PersonApp.class).getContext().getResourceMap(PersonView.class);
            if ("person.name".equals(binding.getName())) {
                if (failure.getType() == SyncFailureType.VALIDATION_FAILED) {
                    nameErrorLabel.setText(resourceMap.getString("input.required.error"));
                }
            }
            else if ("person.age".equals(binding.getName())) {
                if (failure.getType() == SyncFailureType.CONVERSION_FAILED) {
                    ageErrorLabel.setText(resourceMap.getString("number.format.error"));
                }
            }
        }

        public void synced(Binding binding) {
            if ("person.name".equals(binding.getName())) {
                nameErrorLabel.setText("");
            }
            else if ("person.age".equals(binding.getName())) {
                ageErrorLabel.setText("");
            }
        }

        public void sourceChanged(Binding binding, PropertyStateEvent event) {}
        public void targetChanged(Binding binding, PropertyStateEvent event) {}
    }
}
