/*
 * Decompiled with CFR 0.152.
 */
package person;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import person.Person;
import person.PersonAboutBox;
import person.PersonApp;

public class PersonView
extends FrameView {
    JFileChooser fileChooser = new JFileChooser();
    private JLabel ageLabel;
    private JTextField ageTextField;
    private JSeparator jSeparator1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JMenuItem openMenuItem;
    private Person person;
    private JProgressBar progressBar;
    private JMenuItem saveMenuItem;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private BindingGroup bindingGroup;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons;
    private int busyIconIndex;
    private JDialog aboutBox;

    public PersonView(SingleFrameApplication app) {
        super(app);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.busyIcons = new Icon[15];
        this.busyIconIndex = 0;
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersonView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersonView.this.busyIconIndex = (PersonView.this.busyIconIndex + 1) % PersonView.this.busyIcons.length;
                PersonView.this.statusAnimationLabel.setIcon(PersonView.this.busyIcons[PersonView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!PersonView.this.busyIconTimer.isRunning()) {
                        PersonView.this.statusAnimationLabel.setIcon(PersonView.this.busyIcons[0]);
                        PersonView.this.busyIconIndex = 0;
                        PersonView.this.busyIconTimer.start();
                    }
                    PersonView.this.progressBar.setVisible(true);
                    PersonView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    PersonView.this.busyIconTimer.stop();
                    PersonView.this.statusAnimationLabel.setIcon(PersonView.this.idleIcon);
                    PersonView.this.progressBar.setVisible(false);
                    PersonView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    PersonView.this.statusMessageLabel.setText(text == null ? "" : text);
                    PersonView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    PersonView.this.progressBar.setVisible(true);
                    PersonView.this.progressBar.setIndeterminate(false);
                    PersonView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = PersonApp.getApplication().getMainFrame();
            this.aboutBox = new PersonAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        PersonApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.mainPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.ageLabel = new JLabel();
        this.ageTextField = new JTextField();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.person = new Person();
        this.mainPanel.setName("mainPanel");
        this.nameLabel.setDisplayedMnemonic('N');
        this.nameLabel.setLabelFor(this.nameTextField);
        ResourceMap resourceMap = Application.getInstance(PersonApp.class).getContext().getResourceMap(PersonView.class);
        this.nameLabel.setText(resourceMap.getString("nameLabel.text", new Object[0]));
        this.nameLabel.setName("nameLabel");
        this.nameTextField.setName("nameTextField");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.person, (Property)ELProperty.create((String)"${name}"), (Object)this.nameTextField, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.ageLabel.setDisplayedMnemonic('A');
        this.ageLabel.setLabelFor(this.ageTextField);
        this.ageLabel.setText(resourceMap.getString("ageLabel.text", new Object[0]));
        this.ageLabel.setName("ageLabel");
        this.ageTextField.setName("ageTextField");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.person, (Property)ELProperty.create((String)"${age}"), (Object)this.ageTextField, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.ageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ageTextField, -1, 325, Short.MAX_VALUE).addComponent(this.nameTextField, -1, 325, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ageLabel).addComponent(this.ageTextField, -2, -1, -2)).addContainerGap(162, Short.MAX_VALUE)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(PersonApp.class).getContext().getActionMap(PersonView.class, this);
        this.openMenuItem.setAction(actionMap.get("openPersonFile"));
        this.openMenuItem.setMnemonic('O');
        this.openMenuItem.setName("openMenuItem");
        fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setAction(actionMap.get("savePersonFile"));
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setName("saveMenuItem");
        fileMenu.add(this.saveMenuItem);
        this.jSeparator1.setName("jSeparator1");
        fileMenu.add(this.jSeparator1);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setMnemonic('X');
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 400, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 214, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
        this.bindingGroup.bind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void openPersonFile() {
        JFrame parent = PersonApp.getApplication().getMainFrame();
        if (this.fileChooser.showOpenDialog(parent) != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.storePerson((Person)ois.readObject());
        }
        catch (IOException ex) {
            this.fileError(file, "file.open.error", ex);
        }
        catch (ClassNotFoundException ex) {
            this.fileError(file, "file.open.error", ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(PersonView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void savePersonFile() {
        JFrame parent = PersonApp.getApplication().getMainFrame();
        if (this.fileChooser.showSaveDialog(parent) != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            oos.writeObject(this.person);
        }
        catch (IOException ex) {
            this.fileError(file, "file.save.error", ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {
                    this.fileError(file, "file.save.error", ex);
                }
            }
        }
    }

    void fileError(File file, String messageKey, Throwable cause) {
        JFrame parent = PersonApp.getApplication().getMainFrame();
        ResourceMap resourceMap = Application.getInstance(PersonApp.class).getContext().getResourceMap(PersonView.class);
        JOptionPane.showMessageDialog(parent, String.format(resourceMap.getString(messageKey, new Object[0]), file.getAbsolutePath()));
        Logger.getLogger(PersonView.class.getName()).log(Level.SEVERE, null, cause);
    }

    void storePerson(Person newPerson) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(Person.class);
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!pd.isBound()) continue;
                Method reader = pd.getReadMethod();
                Method writer = pd.getWriteMethod();
                if (reader == null || writer == null) continue;
                writer.invoke((Object)this.person, reader.invoke((Object)newPerson, new Object[0]));
            }
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }
}

