package test;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class Test {
    static final String DB_PATH = "c:/data";
    static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    static final String DB_URL = "jdbc:derby:" + DB_PATH + "/test";
    Connection conn;
    Connection getConnection() throws SQLException, ClassNotFoundException {
        if (conn == null) {
            Class.forName(DRIVER_CLASS_NAME);
            conn = DriverManager.getConnection(DB_URL);
        }
        return conn;
    }

    void closeConnection() throws SQLException {
        if (conn != null) conn.close();
    }

    void run() {
        try {
            File dbpath = new File(DB_PATH);
            if (! dbpath.exists()) {
                createDB();
                createTable();
            }
            insertRow();
            queryRow();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                closeConnection();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    void createDB() throws ClassNotFoundException, SQLException {
        System.err.print("Create database...");
        Class.forName(DRIVER_CLASS_NAME);
        conn = DriverManager.getConnection(DB_URL + ";create=true");
        System.err.println(" Done!");
    }

    void createTable() throws ClassNotFoundException, SQLException {
        Statement stmt = getConnection().createStatement();
        System.err.print("Create table...");
        stmt.executeUpdate("create table item(itemid varchar(10) not null, " +
                           "itemname varchar(64) not null, " +
                           "unitprice bigint, " +
                           "primary key (itemid))");
        System.err.println(" Done!");
        stmt.close();
    }

    void insertRow() throws ClassNotFoundException, SQLException {
        Statement stmt = null;
        PreparedStatement pstmt = null;

        try {
            stmt = getConnection().createStatement();
            stmt.executeUpdate("delete from item");
            stmt.close();
            pstmt = getConnection().prepareStatement("insert into item values (?, ?, ?)");
            pstmt.setString(1, "1");
            pstmt.setString(2, "");
            pstmt.setInt(3, 100);
            pstmt.execute();
        
            pstmt.setString(1, "2");
            pstmt.setString(2, "΂Ȃ");
            pstmt.setInt(3, 150);
            pstmt.execute();

            pstmt.setString(1, "3");
            pstmt.setString(2, "݂");
            pstmt.setInt(3, 80);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            try {
                if (stmt != null) stmt.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }

            try {
                if (pstmt != null) pstmt.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    void queryRow() throws ClassNotFoundException, SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = getConnection().createStatement();
            rs = stmt.executeQuery("select itemname, unitprice from item order by unitprice");
            while (rs.next()) {
                System.out.println(rs.getString(1) + "    " + rs.getInt(2));
            }
        }
        finally {
            try {
                if (rs != null) rs.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }

            try {
                if (stmt != null) stmt.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    static void shutdownDB() throws SQLException {
        try {
            System.err.print("Shutdown database...");
            DriverManager.getConnection(DB_URL + ";shutdown=true");
        }
        catch (SQLException ex) {
            if (! ex.getSQLState().equals("08006")) throw ex;
        }
        System.err.println(" Done!");
    }

    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread() {
            @Override public void run() {
                try {
                    shutdownDB();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        });
        new Test().run();
    }
}
